<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\User;

class Signin extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        return $base['signin'];
    }
    
    public static function signin($user_id){
        $config = self::getSet();
        
        if($config['status'] != 1){
            return __json(0,"未开启签到");
        }
        
        $user = User::getInfo($user_id);
        
        if(empty($user)){
            return __json(0,"用户信息错误");
        }
        
        $today_time = strtotime(date("Y-m-d 00:00:00"));
        if($user['signin_time'] > $today_time){
            return __json(0,"今日已签到");
        }
        
        $total = round($config['signin_reward'],2);
        $type = 2;
        if($config['reward_type'] != 2){
            $type = 1;
        }
        
        $continuity_signin_day = max(0,$user['continuity_signin_day']);
        $total_continuity_signin_day = max(0,$user['total_continuity_signin_day']);
        if($continuity_signin_day >= $config['day']){
            $continuity_signin_day = 0;
        }
        
        $yesterday_time = strtotime(date("Y-m-d 00:00:00")." -1 day");
        
        if($user['signin_time'] > $yesterday_time && $user['signin_time'] <= $today_time){
            $continuity_signin_day += 1;
            $total_continuity_signin_day += 1;
        }
        else{
            $continuity_signin_day = 1;
            $total_continuity_signin_day = 1;
        }
        
        $continuity_signin_rule = $config['continuity_signin_rule'];
        foreach ($continuity_signin_rule as $key => $val){
            $day = intval($val['day']);
            $reward = round($val['signin_reward'],2);
            if($day > 0 && $continuity_signin_day == $day && $reward > 0){
                $type = 2;
                if($val['reward_type'] != 2){
                    $type = 1;
                }
                $total = $reward;
            }
        }
        $total_signin_day = $user['total_signin_day'] + 1;
        
        if($total <= 0){
            return __json(0,"未配置签到奖励");
        }
        
        try {
            Db::startTrans();
            
            $data = array(
                "uniacid"=>UNIACID,
                "user_id"=>$user['id'],
                "title"=>"签到奖励",
                "total"=>$total,
                "type"=>$type,
                "date"=>date("Y-m-d"),
                "createtime"=>time()
            );
            
            $id = Db::name("bbfx_signin_record")->insertGetId($data);
            $data['id'] = $id;
            $res = User::setUserMoney($user['id'],$total,$type,34,"签到奖励",$data);
            if(empty($res)){
                throw new \Exception("签到失败");
            }
            
            $udata = [
                'signin_time'=>time(),
                'continuity_signin_day'=>$continuity_signin_day,
                'total_continuity_signin_day'=>$total_continuity_signin_day,
                'total_signin_day'=>$total_signin_day
            ];
            
            Db::name("bbfx_user")->where(['id'=>$user['id']])->update($udata);
            
            $result = __json(1,"签到成功");
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            $result = __json(0,$e->getMessage());
        }
        
        return $result;
    }
    
    // public static function 
}