<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\sale;

use app\api\controller\Base;
use think\Db;


class Coupon extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
    }
    
    public function receive(){
        $params = $this->param();
        
        $coupon = Db::name("bbfx_coupon")->where("id",$params['id'])->where("status",1)->find();
        if(empty($coupon)){
            __error("优惠券不存在或已下架");
        }
        
        $user_coupon = Db::name("bbfx_user_coupon")->where(['coupon_id'=>$coupon['id'],'user_id'=>$this->user['id'],'receive_type'=>1])->find();
        if(!empty($user_coupon)){
            __error("已领取");
        }
        
        $user_ids = [$this->user['id']];
        
        \app\common\model\bbfxshop\Coupon::receive($coupon,$user_ids,1);
        
        __success("领取成功");
    }

    public function getUserCouponList(){
        $params = $this->param();
        
        $where = ['uniacid'=>UNIACID,'user_id'=>$this->user['id']];
        if($params['type'] == 1){
            // $where['endtime'] = ['>',time()];
            $where['status'] = 0;
            
            $price = floatval($params['price']);
            
            $where['mj_money'] = ['<=',$price];
        }
        
        
        $coupon_list = Db::name("bbfx_user_coupon")->where($where)->select();
        $list = [];
        if($params['type'] == 1){
            if(!empty($coupon_list)){
                
                $goods_id = intval($params['goods_id']);
                $goods_ids = [];
                if(!empty($params['cart_id'])){
                    $cart_id = explode(",",$params['cart_id']);
                    $cart = Db::name("bbfx_user_cart")->where(['id'=>['in',$cart_id],'user_id'=>$this->user['id']])->select();
                    foreach ($cart as $key => $val){
                        $goods_ids[] = $val['goods_id'];
                    }
                }
                else{
                    $goods_ids[] = $goods_id;
                }
                
                $goods = Db::name("bbfx_goods")->where(['id'=>['in',$goods_ids]])->field("id,plugin")->select();
                $is_nouse_coupon = false;
                foreach ($goods as $key => $val){
                    $plugin = iunserializer($val['plugin']);
                    if(empty($plugin) || empty($plugin['coupon']) || (!empty($plugin) && !empty($plugin['coupon']) && $plugin['coupon']['is_nouse_coupon'] != 1)){
                        $is_nouse_coupon = true;
                    }
                }
                
                foreach ($coupon_list as $key => $coupon){
                    $flag = false;
                    
                    if($coupon['endtime'] == 0 || ($coupon['endtime'] > 0 && $coupon['endtime'] > time())){
                        if($coupon['condition_type'] == 1){
                            $coupon_goods_ids = explode(",",$coupon['goods_ids']);
                            foreach ($goods_ids as $k => $v){
                                if(in_array($v,$coupon_goods_ids)){
                                    $flag = true;
                                }
                            }
                        }
                        else{
                            $flag = true;
                        }
                    }
                    
                    if($flag && $is_nouse_coupon){
                        $list[] = $coupon;
                    }
                }
            }
        }
        else{
            $list = $coupon_list;
        }
        
        foreach ($list as $key => &$coupon){
            if($coupon['endtime'] > 0){
                $coupon['endtime'] = date("Y-m-d H:i:s",$coupon['endtime']);
            }
            $coupon['money'] = floatval($coupon['money']);
            $coupon['mj_money'] = floatval($coupon['mj_money']);
        }
        unset($coupon);
        
        __success("操作成功",$list);
    }
}