<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\fenxiao;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\ReturnMode;


class Index extends Base
{
    protected $noNeedLogin = ['getLevel'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }

    public function index(){
        global $_W;
        $set = $_W['base'];
        
        if($set['fenxiao']['is_becomedue'] != 1){
            if($this->user['is_distributor'] != 1){
                __error(104,'您暂无权限访问！');
            }
        }
        else{
            if($this->user['is_distributor'] != 1 && $this->user['distributor_status'] == 1){
                // __error(104,'您的分销商身份已到期，到期后将无法获得佣金收益！');
            }
        }
        
        if($this->user['distributor_status'] != 1){
            if($set['fenxiao']['become_agent'] == 4){
                $apply = Db::name("bbfx_fenxiao_apply")->where("user_id",$this->user['id'])->find();
                if(!empty($apply)){
                    if($apply['status'] == 2){
                        __error(104,'审核未通过！');
                    }
                }
                else{
                    __error(104,'您暂无权限访问！');
                }
            }
            
            __error(105,'您暂无权限访问！');
        }
        

        $info = $this->model->getCommissionStatistics($this->user['id']);
        $info['texts'] = $set['fenxiao']['texts'];
        $info['leveldata'] = $this->model->getLevel($this->user['level']);
        $info['user'] = $this->user;
        
        $info['freeze_commission'] = round($info['user']['freeze_money'] + $info['user']['freeze_commission'],2);
        
        $return = ReturnMode::getReturnStatistics($this->user['id']);
        
        $info = array_merge($info,$return);
        
        $info['max_strikeout_money'] = \app\common\model\bbfxshop\Strikeout::getMaxStrikeoutMoney($this->user['id']);
        
        $user_apply = 0;
        $user_shenhe_apply = 0;
        $levels = $this->model->getLevels(1);
        $up_type = $set['fenxiao']['up_type'];
        if(in_array(14,$up_type) && $set['fenxiao']['user_shenhe_apply'] == 1){
            if($levels[$this->user['level']]['user_shenhe_apply'] == 1){
                $user_shenhe_apply = 1;
                $sort = $levels[$this->user['level']]['sort'];
                $level_ids = [];
                foreach ($levels as $key => $val){
                    if($sort > $val['sort']){
                        $level_ids[] = $val['id'];
                    }
                }
                
                $level_user1 = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'sup_uid'=>$this->user['id']])->field("id")->select();
                
                if(!empty($level_user1)){
                    $uids = array_column($level_user1, 'id');
                    $user_apply = Db::name("bbfx_fenxiao_apply")->where(['uniacid'=>UNIACID,'user_id'=>['in',$uids],'status'=>0,'level'=>['in',$level_ids]])->count();
                }
                
                
            }
        }
        
        $info['user_apply'] = $user_apply;
        $info['user_shenhe_apply'] = $user_shenhe_apply;
        $info['becomedue_tips'] = '您的分销商身份已到期，到期后将无法获得佣金收益！';
        
        $texts = $info['texts'];
        $fenxiao = $set['fenxiao'];
        $navItems = [];
        $icoUrl = request()->domain()."/assets/images/";
        $user = $this->user;
        
        $navItems = [
            [
                'title' => $texts['commission_total'],
                'value' => $info['commission_total'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/z-yj.png',
                'icon1' => $icoUrl.'commission_total.png',
                'link' => '/pages/fenxiao/order?type=-1',
                'unit' => $texts['yuan'],
                'show'=>1
            ],
            [
                'title' => $texts['user_shenhe_apply'],
                'value' => $info['user_apply'] ?: '0',
                'icon' => $icoUrl.'fenxiao/xx.png',
                'icon1' => $icoUrl.'fenxiao/xx.png',
                'link' => '/pages/fenxiao/applyList',
                'unit' => '人',
                'show'=>$info['user_shenhe_apply']
            ],
            [
                'title' => $texts['commission_order'],
                'value' => $info['commission_order'] ?: '0',
                'icon' => $icoUrl.'fenxiao/fx-order.png',
                'icon1' => $icoUrl.'commission_order.png',
                'link' => '/pages/fenxiao/order',
                'unit' => '笔',
                'show'=>1
            ],
            [
                'title' => $texts['withdrawal_log'],
                'value' => $info['withdrawal_num'] ?: '0',
                'icon' => $icoUrl.'fenxiao/tx.png',
                'icon1' => $icoUrl.'withdrawal_log.png',
                'link' => '/pages/fenxiao/withdrawal/list',
                'unit' => '笔',
                'show'=>1
            ],
            [
                'title' => $texts['level1_team'],
                'value' => $info['level1_team_user'] ?: '0',
                'icon' => $icoUrl.'fenxiao/xx.png',
                'icon1' => $icoUrl.'level1_team.png',
                'link' => '/pages/fenxiao/down?level=1',
                'unit' => '人',
                'show'=>1
            ],
            [
                'title' => $texts['jc_reward'],
                'value' => $info['jc_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/jcj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=4',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_jicha']
            ],
            [
                'title' => $texts['jd_reward'],
                'value' => $info['jd_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/jdj.png',
                'icon1' => $icoUrl.'jd_reward.png',
                'link' => '/pages/fenxiao/order?type=5',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_jiandan']
            ],
            [
                'title' => $texts['pj_reward'],
                'value' => $info['pj_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/pjj.png',
                'icon1' => $icoUrl.'pj_reward.png',
                'link' => '/pages/fenxiao/order?type=6',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_pingji']
            ],
            [
                'title' => $texts['repurchase_reward'],
                'value' => $info['repurchase_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/fugoujiang.png',
                'icon1' => $icoUrl.'fenxiao/style1/fugoujiang.png',
                'link' => '/pages/fenxiao/order?type=17',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_repurchase']
            ],
            [
                'title' => $texts['repurchase_pingji_reward'],
                'value' => $info['repurchase_pingji_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/fgj.png',
                'icon1' => $icoUrl.'pj_reward.png',
                'link' => '/pages/fenxiao/order?type=16',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_repurchase_pingji']
            ],
            [
                'title' => $texts['ab_reward'],
                'value' => $info['ab_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/jiaquanfenhong.png',
                'icon1' => $icoUrl.'ab_reward.png',
                'link' => '/pages/fenxiao/order?type=7',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_abonus']
            ],
            [
                'title' => $texts['ladderabonus_reward'],
                'value' => $info['ladderabonus_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/jietifenhong.png',
                'icon1' => $icoUrl.'fenxiao/style1/jietifenhong.png',
                'link' => '/pages/fenxiao/order?type=19',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_ladder_abonus']
            ],
            [
                'title' => $texts['cloud_warehouse_fanhuan_reward'],
                'value' => $info['cloud_warehouse_fanhuan_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/yuncangjinhuojiangli.png',
                'icon1' => $icoUrl.'fenxiao/style1/yuncangjinhuo.png',
                'link' => '/pages/fenxiao/order?type=20',
                'unit' => $texts['yuan'],
                'show'=>$set['cloud_warehouse']['status']
            ],
            [
                'title' => $texts['cloud_warehouse_chuhuo_reward'],
                'value' => $info['cloud_warehouse_chuhuo_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/yuncangchuhuojiangli.png',
                'icon1' => $icoUrl.'fenxiao/style1/yuncangchuhuo.png',
                'link' => '/pages/fenxiao/order?type=21',
                'unit' => $texts['yuan'],
                'show'=>$set['cloud_warehouse']['status']
            ],
            [
                'title' => $texts['appoint_reward'],
                'value' => $info['appoint_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/zhiding.png',
                'icon1' => $icoUrl.'fenxiao/style1/zhiding.png',
                'link' => '/pages/fenxiao/order?type=22',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_appoint']
            ],
            [
                'title' => $texts['appoint_user'] ?: '指定用户',
                'value' => '',
                'icon' => $icoUrl.'fenxiao/zhidingyonghu.png',
                'icon1' => $icoUrl.'fenxiao/style1/zhidingyonghu.png',
                'link' => '/pages/appoint/user',
                'unit' => '',
                'show'=>$fenxiao['is_appoint']
            ],
            [
                'title' => $texts['directpush_achievement_reward'],
                'value' => $info['directpush_achievement_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/zhituiyeji.png',
                'icon1' => $icoUrl.'fenxiao/style1/zhituiyeji.png',
                'link' => '/pages/fenxiao/order?type=23',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_directpush_achievement']
            ],
            [
                'title' => $texts['directpush_jiandan_reward'],
                'value' => $info['directpush_jiandan_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/zhituijiandan.png',
                'icon1' => $icoUrl.'fenxiao/style1/zhituijiandan.png',
                'link' => '/pages/fenxiao/order?type=24',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_directpush_jiandan']
            ],
            [
                'title' => $texts['cloud_warehouse_stock'] ?: '云仓库存',
                'value' => $user['cloud_warehouse_stock'] ?: '0',
                'icon' => $icoUrl.'fenxiao/yuncangkucun.png',
                'icon1' => $icoUrl.'fenxiao/style1/yuncangkucun.png',
                'link' => '',
                'unit' => '',
                'show'=>$set['cloud_warehouse']['status']
            ],
            [
                'title' => $texts['below_reward'],
                'value' => $info['below_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/xiaerdaijiang.png',
                'icon1' => $icoUrl.'fenxiao/style1/xiaerdaijiang.png',
                'link' => '/pages/fenxiao/order?type=27',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_below']
            ],
            [
                'title' => $texts['team_building_reward'],
                'value' => $info['team_building_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/tuanjianjiang.png',
                'icon1' => $icoUrl.'fenxiao/style1/tuanjianjiang.png',
                'link' => '/pages/fenxiao/order?type=28',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_team_building']
            ],
            [
                'title' => $texts['agent_reward'],
                'value' => $info['agent_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'fenxiao/style1/dailiyongjin.png',
                'link' => '/pages/fenxiao/order?type=11',
                'unit' => $texts['yuan'],
                'show'=>$set['agent']['status']
            ],
            [
                'title' => $texts['sgmanagement_reward'],
                'value' => $info['sgmanagement_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/gl.png',
                'icon1' => $icoUrl.'smanagement_reward.png',
                'link' => '/pages/fenxiao/order?type=14',
                'unit' => $texts['yuan'],
                'show'=>$set['double_track']['status']
            ],
            [
                'title' => $texts['management_reward'],
                'value' => $info['management_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/tuanduiguanli.png',
                'icon1' => $icoUrl.'fenxiao/style1/guanlijiang.png',
                'link' => '/pages/fenxiao/order?type=15',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_management']
            ],
            [
                'title' => $texts['management_assistant_reward'],
                'value' => $info['management_assistant_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/tuanduiguanli.png',
                'icon1' => $icoUrl.'fenxiao/style1/guanlijiang.png',
                'link' => '/pages/fenxiao/order?type=32',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_management_assistant_reward']==1&&$fenxiao['is_management_assistant_reward']==1?1:0
            ],
            [
                'title' => $texts['directpush_team_reward'],
                'value' => $info['directpush_team_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/zhituituandui.png',
                'icon1' => $icoUrl.'fenxiao/style1/zhituituandui.png',
                'link' => '/pages/fenxiao/order?type=29',
                'unit' => $texts['yuan'],
                'show'=>$set['directpush_team']['status']
            ],
            [
                'title' => $texts['sabonus_reward'],
                'value' => $info['sabonus_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/gufenjiaquanfenhong.png',
                'icon1' => $icoUrl.'fenxiao/style1/gufenjiaquanfenhong.png',
                'link' => '/pages/fenxiao/order?type=30',
                'unit' => $texts['yuan'],
                'show'=>$set['sabonus']['status']
            ],
            [
                'title' => $texts['sabonus_part'],
                'value' => $info['sabonus_part'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/gufenjiaquanfenhong.png',
                'icon1' => $icoUrl.'fenxiao/style1/gufenjiaquanfenhong.png',
                'link' => '',
                'unit' => $texts['yuan'],
                'show'=>$set['sabonus']['status']
            ],
            [
                'title' => $texts['repurchase_currency'],
                'value' => $user['repurchase_currency'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/fugoujin.png',
                'icon1' => $icoUrl.'fenxiao/style1/fugoujin.png',
                'link' => '',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_repurchase_gold']
            ],
            [
                'title' => $texts['contribute_reward'],
                'value' => $info['contribute_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/gl.png',
                'icon1' => $icoUrl.'contribute_reward.png',
                'link' => '/pages/fenxiao/order?type=12',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_abonus']==1&&$fenxiao['abonus_rule']==3&&$fenxiao['contribute_status']==1?1:0
            ],
            [
                'title' => '返还'.$set['texts']['score'],
                'value' => $info['return_score'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/fh.png',
                'icon1' => $icoUrl.'fenxiao/style1/fanhuanyue.png',
                'link' => '/pages/return/list?type=2',
                'unit' => $set['texts']['score_unit'],
                'show'=>$set['return']['status']==1&&$set['return']['currency']==2?1:0
            ],
            [
                'title' => '返还'.$set['texts']['balance'],
                'value' => $info['return_balance'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/fh.png',
                'icon1' => $icoUrl.'fenxiao/style1/fanhuanyue.png',
                'link' => '/pages/return/list?type=1',
                'unit' => $set['texts']['balance_unit'],
                'show'=>$set['return']['status']==1&&$set['return']['currency']==1?1:0
            ],
            [
                'title' => '大市场团队',
                'value' => $info['dashichang'] ?: '0',
                'icon' => $icoUrl.'fenxiao/gl.png',
                'icon1' => $icoUrl.'dashichang.png',
                'link' => '',
                'unit' => '人',
                'show'=>$fenxiao['is_market']
            ],
            [
                'title' => '小市场团队',
                'value' => $info['xiaoshichang'] ?: '0',
                'icon' => $icoUrl.'fenxiao/gl.png',
                'icon1' => $icoUrl.'xiaoshichang.png',
                'link' => '',
                'unit' => '人',
                'show'=>$fenxiao['is_market']
            ],
            [
                'title' => $texts['chaoyue_reward'],
                'value' => $info['chaoyue_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=31',
                'unit' => $texts['yuan'],
                'show'=>$set['chaoyue']['status']
            ],
            [
                'title' => $texts['ladderpingji_reward'],
                'value' => $info['ladderpingji_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=33',
                'unit' => $texts['yuan'],
                'show'=>$set['ladderpingji']['status']
            ],
            [
                'title' => $texts['crazy_abonus_reward'],
                'value' => $info['crazy_abonus_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=34',
                'unit' => $texts['yuan'],
                'show'=>$set['crazy']['status']
            ],
            [
                'title' => $texts['npingji_reward'],
                'value' => $info['npingji_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=35',
                'unit' => $texts['yuan'],
                'show'=>$set['npingji']['status']
            ],
            [
                'title' => $texts['achievement_subsidy_reward'],
                'value' => $info['achievement_subsidy_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=36',
                'unit' => $texts['yuan'],
                'show'=>$set['agent']['achievement_subsidy']['status']
            ],
            [
                'title' => $texts['tixian_abonus_reward'],
                'value' => $info['tixian_abonus_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=37',
                'unit' => $texts['yuan'],
                'show'=>$set['txabonus']['status']
            ],
            [
                'title' => $texts['paihangbang_abonus_reward'],
                'value' => $info['paihangbang_abonus_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=38',
                'unit' => $texts['yuan'],
                'show'=>$set['paihangbang']['status']
            ],
            [
                'title' => $texts['super_maihuo_abonus_reward'],
                'value' => $info['super_maihuo_abonus_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=39',
                'unit' => $texts['yuan'],
                'show'=>$set['super_maihuo']['status']
            ],
            [
                'title' => $texts['ladderabonus_pingji_reward'],
                'value' => $info['ladderabonus_pingji_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=40',
                'unit' => $texts['yuan'],
                'show'=>$fenxiao['is_ladder_abonus_pingji']
            ],
            [
                'title' => $texts['super_maihuo_sup_reward'],
                'value' => $info['super_maihuo_sup_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=41',
                'unit' => $texts['yuan'],
                'show'=>$set['super_maihuo']['status']
            ],
            [
                'title' => $texts['laddermanage_reward'],
                'value' => $info['laddermanage_reward'] ?: '0.00',
                'icon' => $icoUrl.'fenxiao/dlyj.png',
                'icon1' => $icoUrl.'jc_reward.png',
                'link' => '/pages/fenxiao/order?type=42',
                'unit' => $texts['yuan'],
                'show'=>$set['laddermanage']['status']
            ]
        ];
        
        $info['navItems'] = $navItems;
        
        __success("操作成功",$info);
    }
    
    public function apply(){
        global $_W;
        $set = $_W['base'];
        
        
        $params = $this->paramPost(['realname/s','mobile/s','level/d']);
        if(empty($params['realname'])){
            __error("请填写姓名");
        }
        if(empty($params['mobile'])){
            __error("请填写手机号");
        }
        $level = intval($params['level']);
        $levels = $this->model->getLevels(1);
        if($level == -1){
            $nextLevel = $this->user['nextLevel'];
            if(empty($nextLevel)){
                __error("未开启申请");
            }
            
            if($nextLevel['id'] != 0){
                if($nextLevel['apply'] != 1){
                    __error("该等级暂不支持申请");
                }
            }
            else{
                if($set['fenxiao']['become_agent'] != 4){
                    __error("未开启申请");
                }
            }
            $level = $nextLevel['id'];
        }
        else{
            
            if(empty($levels[$level])){
                __error("申请等级错误");
            }
            
            if($level != 0){
                if($levels[$level]['conditions']['apply'] != 1){
                    __error("该等级暂不支持申请");
                }
            }
            else{
                if($set['fenxiao']['become_agent'] != 4){
                    __error("未开启申请");
                }
            }
        }
        
        if(empty($levels[$level])){
            __error("申请等级错误");
        }
        
        if($this->user['is_distributor'] = 1 && $this->user['distributor_status'] == 1){
            if($levels[$this->user['level']]['level'] >= $levels[$level]['level']){
                __error("不可申请低等级");
            }
        }
        
        
        $apply = Db::name("bbfx_fenxiao_apply")->where(["user_id"=>$this->user['id'],'level'=>$level])->find();
        if(!empty($apply)){
            if($apply['status'] == 0){
                __error("您已提交申请，请等待审核");
            }
        }
        
        $data = array(
            'uniacid'=>UNIACID,
            'user_id'=>$this->user['id'],
            'realname'=>$params['realname'],
            'mobile'=>$params['mobile'],
            'status'=>0,
            'level'=>$level,
            'createtime'=>time()
        );
        
        if(!empty($apply)){
            $res = Db::name("bbfx_fenxiao_apply")->where(['id'=>$apply['id']])->update($data);
        }
        else{
            $res = Db::name("bbfx_fenxiao_apply")->insert($data);
        }
        
        if($res){
            __success("提交成功");
        }
        else{
            __error("提交失败");
        }
    }
    
    public function getLevel(){
        $id = $this->paramGet("id/d");
        
        $level = $this->model->getLevel($id);
        
        if(empty($level)){
            __error("等级错误");
        }
        
        __success("操作成功",$level);
    }
}