<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\deposit_release;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Fenxiao;


class Index extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\DepositRelease;
    }
    
    public function getPredepositRecordList(){
        $current = $this->param("current/d");
        $page = max(1,$this->param("page/d"));
        $limit = 20;
        
        $where = ['uniacid'=>UNIACID,'type'=>6,'user_id'=>$this->user['id']];
        if($current == 1){
            $where['money'] = ['>',0];
        }
        else if($current == 2){
            $where['money'] = ['<',0];
        }
        
        $list = Db::name("bbfx_money_log")->where($where)->field("id,money,befores,afters,remarks,type,item_type,item_id,createtime")->order("createtime desc,id desc")->limit(($page-1)*$limit,$limit)->select();
        
        $total = Db::name("bbfx_money_log")->where($where)->count();
        
        foreach ($list as $key => &$val){
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            if($val['money'] > 0){
                $val['moneyText'] = "+".$val['money'];
            }
            else{
                $val['moneyText'] = $val['money'];
            }
            $info = iunserializer($val['info']);
            $val['info'] = $info;
            if($val['item_type'] == 3){
                $val['title'] = $info['notes'];
            }
        }
        unset($val);
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
}