<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\cloud_warehouse;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Goods extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\CloudWarehouse;
    }
    
    public function index(){
        
        $config = $this->model->getSet();
        $cw_goods = [-1];
        if(!empty($config['cw_goods'])){
            $cw_goods = explode(",",(string)$config['cw_goods']);
        }
        
        $goods = Db::name("bbfx_goods")->where(['id'=>['in',$cw_goods]])->field("id,title,thumb,price")->order("sort desc,id desc")->select();
        if(empty($goods)){
            $goods = [];
        }
        
        foreach ($goods as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
        }
        unset($val);
        
        __success("操作成功",['goods'=>$goods]);
    }
    
    public function deliveryInfo(){
        $config = $this->model->getSet();
        $params = $this->param(['goods_id/d']);
        $goods_id = $params['goods_id'];
        
        $cw_goods = explode(",",(string)$config['cw_goods']);
        if(!in_array($params['goods_id'],$cw_goods)){
            $goods_id = $cw_goods[0];
        }
        
        $goods = Db::name("bbfx_goods")->where(['id'=>$goods_id])->find();
        if(empty($goods)){
            __error("商品错误");
        }
        
        $goods = Db::name("bbfx_cloud_warehouse_goods")->alias("a")->join("bbfx_goods b","a.goods_id=b.id","LEFT")->where(['a.user_id'=>$this->user['id'],'a.goods_id'=>$goods_id])->field("a.*,b.title,b.thumb,b.type")->select();
        if(empty($goods)){
            __error("商品库存不足");
        }
        
        foreach ($goods as $key => &$val){
            $val['total'] = 0;
            $val['thumb'] = cdnurl($val['thumb']);
        }
        unset($val);
        
        __success("操作成功",['goods'=>$goods]);
    }
    
    public function takeDeliveryGoods(){
        $params = $this->param(['goods/a','address_id/d']);
        
        $result = $this->model->takeDeliveryGoods($this->user['id'],$params['goods'],$params['address_id']);
        if($result['code'] == 1){
            __success("提交提货成功");
        }
        else{
            __error($result['message']);
        }
    }
    
    public function getRecordList(){
        $config = $this->model->getSet();
        $params = $this->param(['page/d','current/d','goods_id/d']);
        
        $user = $this->user;
        
        $page = max(1,intval($params['page']));
        $psize = 20;
        $where = ['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>1];
        if($params['current'] == 1){
            $where['stock'] = ['>',0];
            $where['item_type'] = 1;
        }
        else if($params['current'] == 2){
            $where['stock'] = ['<',0];
            $where['item_type'] = 2;
        }
        else if($params['current'] == 3){
            $where['stock'] = ['<',0];
            $where['item_type'] = 4;
        }
        
        $cw_goods = [-1];
        if(!empty($config['cw_goods'])){
            $cw_goods = explode(",",(string)$config['cw_goods']);
        }
        $goods = Db::name("bbfx_goods")->where(['id'=>['in',$cw_goods]])->field("id,title,thumb,price")->order("sort desc,id desc")->select();
        
        if($params['goods_id'] <= 0){
            $goods_id = $goods[0]['id'];
        }
        else{
            $goods_id = $params['goods_id'];
        }
        $where['goods_id'] = $goods_id;
        $stock = Db::name("bbfx_cloud_warehouse_goods")->where(['user_id'=>$user['id'],'goods_id'=>$goods_id])->value("stock");
        
        $list = Db::name("bbfx_cloud_warehouse_stock_record")->where($where)->order(['createtime desc','id desc'])->limit(($page-1)*$psize,$psize)->select();
        
        $jinhuo_stock = 0;
        $chuhuo_stock = 0;
        $total_stock = 0;
        $tihuo_stock = 0;
        if($page == 1){
            $jinhuo_stock = Db::name("bbfx_cloud_warehouse_stock_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>1,'stock'=>['>',0]])->sum("stock");
            $chuhuo_stock = Db::name("bbfx_cloud_warehouse_stock_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>1,'stock'=>['<',0]])->sum("stock");
            $chuhuo_stock = abs($chuhuo_stock);
            $total_stock = $jinhuo_stock;
            
            $tihuo_stock = Db::name("bbfx_cloud_warehouse_stock_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>1,'item_type'=>4,'stock'=>['<',0]])->sum("stock");
            $tihuo_stock = abs($tihuo_stock);
        }
        $result = ['list'=>[],'stock'=>intval($stock),'total_stock'=>intval($total_stock),'tihuo_stock'=>intval($tihuo_stock),'jinhuo_stock'=>intval($jinhuo_stock),'chuhuo_stock'=>intval($chuhuo_stock)];
        
        if(empty($list)){
            __error($page==1?'暂无记录~':'没有更多了~',$result);
        }
        else{
            foreach ($list as $key => &$val){
                if($val['stock'] > 0){
                    $val['stockText'] = "+".$val['stock'];
                }
                else{
                    $val['stockText'] = $val['stock'];
                }
                $info = iunserializer($val['info']);
                if($val['item_type'] == 2){
                    $money = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'type'=>21,'order_id'=>$info['order_id'],'og_id'=>$info['id']])->value("money");
                    $money = floatval($money);
                    $val['cloud_warehouse_chuhuo_reward'] = $money;
                }
                
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                unset($val['info']);
            }
            unset($val);
            $result['list'] = $list;
            __success("success",$result);
        }
        
        
    }
}