<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller;

use app\common\exception\UploadException;
use app\common\library\Upload;
use app\common\model\Area;
use app\common\model\Version;
use fast\Random;
use think\captcha\Captcha;
use think\Config;
use think\Hook;
use think\Db;

use app\api\controller\Base;

/**
 * 公共接口
 */
class Common extends Base
{
    protected $noNeedLogin = ['*'];
    protected $noNeedRight = '*';

    public function _initialize()
    {

        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header('Access-Control-Expose-Headers: __token__');//跨域让客户端获取到
        }
        //跨域检测
        check_cors_request();

        if (!isset($_COOKIE['PHPSESSID'])) {
            Config::set('session.id', $this->request->server("HTTP_SID"));
        }
        parent::_initialize();
        
    }

    /**
     * 加载初始化
     *
     * @param string $version 版本号
     * @param string $lng 经度
     * @param string $lat 纬度
     */
    public function init1()
    {
        if ($version = $this->request->request('version')) {
            $lng = $this->request->request('lng');
            $lat = $this->request->request('lat');

            //配置信息
            $upload = Config::get('upload');
            //如果非服务端中转模式需要修改为中转
            if ($upload['storage'] != 'local' && isset($upload['uploadmode']) && $upload['uploadmode'] != 'server') {
                //临时修改上传模式为服务端中转
                set_addon_config($upload['storage'], ["uploadmode" => "server"], false);

                $upload = \app\common\model\Config::upload();
                // 上传信息配置后
                Hook::listen("upload_config_init", $upload);

                $upload = Config::set('upload', array_merge(Config::get('upload'), $upload));
            }

            $upload['cdnurl'] = $upload['cdnurl'] ? $upload['cdnurl'] : cdnurl('', true);
            $upload['uploadurl'] = preg_match("/^((?:[a-z]+:)?\/\/)(.*)/i", $upload['uploadurl']) ? $upload['uploadurl'] : url($upload['storage'] == 'local' ? '/api/common/upload' : $upload['uploadurl'], '', false, true);

            $content = [
                'citydata'    => Area::getCityFromLngLat($lng, $lat),
                'versiondata' => Version::check($version),
                'uploaddata'  => $upload,
                'coverdata'   => Config::get("cover"),
            ];
            $this->success('', $content);
        } else {
            $this->error(__('Invalid parameters'));
        }
    }
    
    public function getExpressList(){
        
        $list = Db::name("bbfx_express")->order("id asc")->select();
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function sendsms(){
        $params = $this->param();
        
        $mobile = $params['mobile'];
        $type = $params['type'];
        if(empty($type)){
            $type = "login";
        }
        
        if(empty($mobile)){
            __error("请输入手机号");
        }
        
        $result = \app\common\model\bbfxshop\Sms::sendCode($mobile,$type);
        if($result['code'] === 1){
            __success("验证码发送成功，请注意查收");
        }
        else{
            __error($result['message']);
        }
    } 

    /**
     * 上传文件
     * @ApiMethod (POST)
     * @param File $file 文件流
     */
    public function upload()
    {
        Config::set('default_return_type', 'json');
        //必须设定cdnurl为空,否则cdnurl函数计算错误
        // Config::set('upload.cdnurl', '');
        $chunkid = $this->request->post("chunkid");
        if ($chunkid) {
            if (!Config::get('upload.chunking')) {
                $this->error(__('Chunk file disabled'));
            }
            $action = $this->request->post("action");
            $chunkindex = $this->request->post("chunkindex/d");
            $chunkcount = $this->request->post("chunkcount/d");
            $filename = $this->request->post("filename");
            $method = $this->request->method(true);
            if ($action == 'merge') {
                $attachment = null;
                //合并分片文件
                try {
                    $upload = new Upload();
                    $attachment = $upload->merge($chunkid, $chunkcount, $filename);
                } catch (UploadException $e) {
                    $this->error($e->getMessage());
                }
                $this->success(__('Uploaded successful'), ['url' => $attachment->url, 'fullurl' => cdnurl($attachment->url, true)]);
            } elseif ($method == 'clean') {
                //删除冗余的分片文件
                try {
                    $upload = new Upload();
                    $upload->clean($chunkid);
                } catch (UploadException $e) {
                    $this->error($e->getMessage());
                }
                $this->success();
            } else {
                //上传分片文件
                //默认普通上传文件
                $file = $this->request->file('file');
                try {
                    $upload = new Upload($file);
                    $upload->chunk($chunkid, $chunkindex, $chunkcount);
                } catch (UploadException $e) {
                    $this->error($e->getMessage());
                }
                $this->success();
            }
        } else {
            $attachment = null;
            //默认普通上传文件
            $file = $this->request->file('file');
            try {
                $upload = new Upload($file);
                $attachment = $upload->upload(null,1);
            } catch (UploadException $e) {
                $this->error($e->getMessage());
            }

            $this->success(__('Uploaded successful'), ['url' => $attachment->url, 'fullurl' => cdnurl($attachment->url)]);
        }

    }

    /**
     * 验证码
     * @param $id
     * @return \think\Response
     */
    public function captcha($id = "")
    {
        \think\Config::set([
            'captcha' => array_merge(config('captcha'), [
                'fontSize' => 44,
                'imageH'   => 150,
                'imageW'   => 350,
            ])
        ]);
        $captcha = new Captcha((array)Config::get('captcha'));
        return $captcha->entry($id);
    }
    
    
    public function getRegions(){
        $provinces = file_get_contents(ROOT_PATH."public/assets/city.json");
        $provinces = json_decode($provinces,true);
        
        if(empty($provinces)){
            __error("地址信息错误",ROOT_PATH."/assets/city.json");
        }
        
        foreach ($provinces as $key => &$val) {
            $val['abb'] = explode("",$val['name'])[0];
        }
        unset($val);
        
        $names = array_column($provinces,'abb');
        array_multisort($names,SORT_DESC,$provinces);
        
        __success("操作成功",$provinces);
    }
    
    public function jssdk(){
        global $_W;
        $params = $this->paramGet(['url/s']);
        
        if(empty($params['url'])){
            __error("URL错误");
        }
        // $params['url'] = "https://dianying.wannengfenxiao.com/mobile/#/";
        $result = \app\common\model\bbfxshop\Weixin::getTicket();
        if($result['code'] != 1){
            __result($result);
        }
        
        $ticket = $result['data'];
        
        $platform = $_W['platform'];
        
        // print_r($ticket);die;
        $noncestr = random(16);
        $timestamp = time();
        $url = urldecode($params['url']);
        $sign_arr = array(
            "jsapi_ticket"=>$ticket,
            "noncestr"=>$noncestr,
            "timestamp"=>$timestamp,
            "url"=>urldecode($params['url'])
        );
        
        
        $sign_str = "jsapi_ticket={$ticket}&noncestr={$noncestr}&timestamp={$timestamp}&url={$url}";
        
        $signature = sha1($sign_str);
        
        // $sign_arr['signature'] = $sign_str;
        // echo "<pre>";
        // print_r($sign_arr);die;
        
        
        $jssdk_config = array(
            "debug"=>false,
            "appId"=>$platform['AppId'],
            "timestamp"=>$timestamp,
            "nonceStr"=>$noncestr,
            "signature"=>$signature,
            "jsApiList"=>array(
                'checkJsApi',
				'onMenuShareTimeline',
				'onMenuShareAppMessage',
				'updateAppMessageShareData',
				'updateTimelineShareData',
				'getLocation',
				'openLocation',
				'requestMerchantTransfer'
			)
        );
        
        $result = array("jssdkconfig"=>$jssdk_config);
        
        __success("操作成功",$result);
    }
}
