<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\fenxiao;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Apply extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        $keyword = trim($params['keyword']);
        $type = max(1,intval($params['type']));
        $where = ["a.uniacid"=>UNIACID,'a.status'=>0];
        if($keyword){
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['a.realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['a.mobile'] = $keyword;
            }
            else if($type == 4){
                $where['a.user_id'] = intval($keyword);
            }
        }
        
        $list = Db::name("bbfx_fenxiao_apply")->alias("a")->join("bbfx_user b","a.user_id = b.id")->where($where)->field("a.*,b.nickname,b.avatar,b.sup_uid")->order("createtime desc")->limit(($pindex-1)*$psize,$psize)->select();
        $levels = $this->model->getLevels(1);
        foreach($list as $key=>&$val){
            $val['avatar'] = cdnurl($val['avatar']);
    	    $val['createtime'] = date("Y.m.d H:i",$val['createtime']);
    	    if($val['sup_uid']){
                $user = Db::name("bbfx_user")->where(['id'=>$val['sup_uid']])->field(['id','avatar','nickname','realname'])->find();
    	        if(!empty($user)){
    	            $user['avatar'] = cdnurl($user['avatar']);
    	            $val['sup_user'] = $user;
    	        }
    	    }
    	    $val['levelname'] = $levels[$val['level']]['title'];
        }
        unset($val);
        
        $total = Db::name("bbfx_fenxiao_apply")->alias("a")->join("bbfx_user b","a.user_id = b.id")->where($where)->count();
        
    	__success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function check(){
        $params = $this->param(['id/d','status/d']);
        $apply = Db::name("bbfx_fenxiao_apply")->where('id',$params['id'])->find();
        if(empty($apply)){
            __error("申请记录不存在");
        }
        $user = \app\common\model\bbfxshop\User::getInfo($apply['user_id']);
        if(empty($user)){
            __error("用户不存在");
        }
        
        $res = Db::name("bbfx_fenxiao_apply")->where('id',$params['id'])->update(['status'=>$params['status']]);
        if($res){
            
            if($params['status'] == 1){
                
                $udata = ['level'=>$apply['level'],'realname'=>$apply['realname'],'mobile'=>$apply['mobile'],'is_distributor'=>1,'distributor_status'=>1];
                
                if($apply['level'] == 0){
                    $udata['become_distributor_time'] = time();
                }
                
                $udata['upgrade_distributor_time'] = time();
                
                $res = Db::name("bbfx_user")->where(['id'=>$apply['user_id']])->update($udata);    
                if($res){
                    \app\common\model\bbfxshop\FenxiaoUpgrade::addUpgradeRecord(2,$user['id'],$udata['level'],$user['level'],$user['sup_uid']);
                }
            }
            else{
                $udata = [];
            }
            
            $udata['id'] = $params['id'];
            $udata['status'] = $params['status'];
            
            \app\admin\model\AdminLog::record("","",$udata,'bbfx_fenxiao_apply');
            
            __success("审核成功");
        }
        else{
            __error('审核失败');
        }
    }
}