<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\agent;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class User extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Agent;
    }
    
    
    public function list(){
        global $_W;
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID,'is_distributor'=>1,'distributor_status'=>1,'agent_status'=>['neq',-1]);
        
        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        $level = trim($params['level']);
        $agent_level = trim($params['agent_level']);
        $type = max(1,intval($params['type']));
        
        if($keyword){
            if($type == 1){
                $where['nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['mobile'] = $keyword;
            }
            else if($type == 4){
                $where['id'] = intval($keyword);
            }
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['become_agent_time'] = ['>=',$startTime];
        }
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['become_agent_time'] = ['<=',$endTime];
        }
        
        if($level != ''){
            $where['level'] = $level;
        }
        
        if($agent_level > 0){
            $where['agent_level'] = $agent_level;
        }
        
        
        $set = $_W['base'];
        
        $list = Db::name("bbfx_user")->where($where)->where($whereTime)->field('id,avatar,nickname,level,createtime,become_agent_time,agent_status,agent_province,agent_city,agent_area,agent_street,is_deputy_city_agent,agent_level,commission_total,sup_uid,realname')->order('createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        
    	$levels = \app\common\model\bbfxshop\Fenxiao::getLevels(1);
    	foreach($list as $key=>&$val){
    	    
    	    $val['levelname'] = $levels[$val['level']]['title'];
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['createtime'] = date("Y.m.d H:i",$val['createtime']);
    	    $val['become_agent_time'] = date("Y.m.d H:i",$val['become_agent_time']);
    	    
    	    if($val['sup_uid']){
                $user = Db::name("bbfx_user")->where(['id'=>$val['sup_uid']])->field(['id','avatar','nickname','realname'])->find();
    	        if(!empty($user)){
    	            $user['avatar'] = cdnurl($user['avatar']);
    	            $val['sup_user'] = $user;
    	        }
    	    }
    	    $commission_total = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'type'=>11,'status'=>1,'user_id'=>$val['id']])->sum('money');
    	    $val['commission_total'] = floatval($commission_total);
    	    
    	    $agentLevelText = "";
    	    if($val['agent_level'] == 1){
    	        $agentLevelText = "省级代理";
    	    }
    	    else if($val['agent_level'] == 2 && $val['is_deputy_city_agent'] != 1){
    	        $agentLevelText = "市级代理";
    	    }
    	    else if($val['agent_level'] == 2 && $val['is_deputy_city_agent'] == 1){
    	        $agentLevelText = "副市级代理";
    	    }
    	    else if($val['agent_level'] == 3){
    	        $agentLevelText = "区级代理";
    	    }
    	    else if($val['agent_level'] == 4){
    	        $agentLevelText = "街道代理";
    	    }
    	    $val['agentLevelText'] = $agentLevelText;
    	    
    	    $agent_region = "";
    	    if($val['agent_level'] > 0){
    	        $agent_region .= $val['agent_province'];
    	    }
    	    if($val['agent_level'] >= 2){
    	        $agent_region .= "-".$val['agent_city'];
    	    }
    	    if($val['agent_level'] >= 3){
    	        $agent_region .= "-".$val['agent_area'];
    	    }
    	    if($val['agent_level'] >= 4){
    	        $agent_region .= "-".$val['agent_street'];
    	    }
    	    
    	    $agent_log = Db::name("bbfx_agent_log")->where(['uniacid'=>UNIACID,'user_id'=>$val['id'],'level'=>$val['agent_level']])->select();
    	    $val['region'] = $agent_log;
    	    $agent_region = [];
    	    foreach ($agent_log as $k => &$v){
    	        $region = "";
    	        if($v['level'] > 0){
        	        $region .= $v['province'];
        	    }
        	    if($v['level'] >= 2){
        	        $region .= "-".$v['city'];
        	    }
        	    if($v['level'] >= 3){
        	        $region .= "-".$v['area'];
        	    }
        	    if($v['level'] >= 4){
        	        $region .= "-".$v['street'];
        	    }
        	    $agent_region[] = $region;
    	    }
    	    unset($v);
    	    
    	    $val['agent_region'] = implode(" ， ",$agent_region);
    	}
    	unset($val);
    	
    	$total = Db::name("bbfx_user")->where($where)->where($whereTime)->count();
    	
    	__success("操作成功",['total'=>$total,'list'=>$list]);
      
    }
    
    
    public function delete(){
        $params = $this->param();
        
        $id = intval($params['id']);
        
        $res = Db::name("bbfx_user")->where(["id"=>$id])->update(['agent_status'=>-1,'agent_level'=>0,'agent_province'=>'','agent_city'=>'','agent_area'=>'','agent_street'=>'','become_agent_time'=>0]);
        
        if($res){
            
            Db::name("bbfx_agent_log")->where(['uniacid'=>UNIACID,'user_id'=>$id])->delete();
            
            \app\admin\model\AdminLog::record("","",["id"=>$id],"bbfx_user");
            
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function setUser(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $region = $params['region'];
        $agent_level = intval($params['agent_level']);
        
        $user = \app\common\model\bbfxshop\User::getInfo($id);
        if(empty($user)){
            __error("用户不存在");
        }
        if($user['agent_status'] != 1){
            __error("不是区域代理");
        }
        if($agent_level <= 0){
            __error("请选择代理级别");
        }
        
        $agent_user_log = Db::name("bbfx_agent_log")->where(['uniacid'=>UNIACID,'user_id'=>$user['id']])->select();
        $log_oks = [];
        foreach ($region as $key => $val){
            if(empty($val['province'])){
                continue;
            } 
            if(!empty($val['id'])){
                $log_oks[$val['id']] = true;
            }
        }
        if(!empty($agent_user_log)){
            foreach ($agent_user_log as $key => $val){
                if(empty($log_oks[$val['id']])){
                    Db::name("bbfx_agent_log")->where(['id'=>$val['id']])->delete();
                }
            } 
        }
        foreach ($region as $key => $val){
            $agent_params = ['id'=>$val['id']];
            $agent_params['province'] = $val['province'];
            $agent_params['city'] = $val['city'];
            $agent_params['area'] = $val['area'];
            $agent_params['street'] = $val['street'];
            
            $result = \app\common\model\bbfxshop\Agent::setRegion($user['id'],$agent_params);
            if($result['code'] != 1 && $result['code'] != 2){
                __error($result['message'],['user_id'=>$user['id']]);
            }
        }
        
        
        $data = array(
            "agent_status"=>1,
            "agent_level"=>$agent_level
        );
        
        $res = Db::name("bbfx_user")->where(['id'=>$id])->update($data);
        if($res){
            $data['id'] = $id;
            \app\admin\model\AdminLog::record("","",$data,"bbfx_user");
        }
        
        __success("操作成功");
    }
    
    public function status(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $status = intval($params['status']);
    	$res = Db::name("bbfx_user")->where(["id"=>$id])->update(["agent_status"=>$status]);
        if($res){
            \app\admin\model\AdminLog::record("","",["id"=>$id,"agent_status"=>$status],"bbfx_user");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
}